/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1604;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_368;

public class Pillager
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgESP;
    private final SettingGroup sgTracers;
    private final SettingGroup sgWebhook;
    private final Setting<Integer> maxDistance;
    private final Setting<Boolean> showCount;
    private final Setting<NotificationMode> notificationMode;
    private final Setting<Boolean> toggleOnFind;
    private final Setting<Boolean> enableDisconnect;
    private final Setting<SettingColor> espColor;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<Boolean> tracersEnabled;
    private final Setting<SettingColor> tracerColor;
    private final Setting<TracersMode> tracersMode;
    private final Setting<Boolean> enableWebhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    private final List<class_1604> pillagers;
    private final Set<Integer> detectedPillagers;
    private int lastPillagerCount;
    private final HttpClient httpClient;

    public Pillager() {
        super(CatalystAddon.esp, "Pillager", "ESP for pillagers with tracers, webhook notifications and info display");
        this.sgGeneral = this.settings.createGroup("General");
        this.sgESP = this.settings.createGroup("ESP");
        this.sgTracers = this.settings.createGroup("Tracers");
        this.sgWebhook = this.settings.createGroup("Webhook");
        this.maxDistance = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-distance")).description("Maximum distance to render pillagers")).defaultValue((Object)128)).range(16, 256).sliderRange(16, 256).build());
        this.showCount = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-count")).description("Show pillager count in chat")).defaultValue((Object)true)).build());
        this.notificationMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("How to notify when pillagers are detected")).defaultValue((Object)NotificationMode.Both)).build());
        this.toggleOnFind = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("toggle-when-found")).description("Automatically toggles the module when pillagers are detected")).defaultValue((Object)false)).build());
        this.enableDisconnect = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disconnect")).description("Automatically disconnect when pillagers are detected")).defaultValue((Object)false)).build());
        this.espColor = this.sgESP.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("esp-color")).description("Color of pillager ESP")).defaultValue(new SettingColor(255, 0, 0, 100)).build());
        this.shapeMode = this.sgESP.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the ESP shapes are rendered")).defaultValue((Object)ShapeMode.Both)).build());
        this.tracersEnabled = this.sgTracers.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers-enabled")).description("Enable tracers to pillagers")).defaultValue((Object)true)).build());
        this.tracerColor = this.sgTracers.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Color of tracers")).defaultValue(new SettingColor(255, 0, 0, 255)).visible(() -> this.tracersEnabled.get())).build());
        this.tracersMode = this.sgTracers.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("tracers-mode")).description("How tracers are rendered")).defaultValue((Object)TracersMode.Line)).visible(() -> this.tracersEnabled.get())).build());
        this.enableWebhook = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook")).description("Send webhook notifications when pillagers are detected")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL")).defaultValue((Object)"")).visible(() -> this.enableWebhook.get())).build());
        this.selfPing = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("self-ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(() -> this.enableWebhook.get())).build());
        this.discordId = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-id")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableWebhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.pillagers = new ArrayList<class_1604>();
        this.detectedPillagers = new HashSet<Integer>();
        this.lastPillagerCount = 0;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void onActivate() {
        this.pillagers.clear();
        this.detectedPillagers.clear();
        this.lastPillagerCount = 0;
    }

    public void onDeactivate() {
        this.pillagers.clear();
        this.detectedPillagers.clear();
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null || event.renderer == null) {
            return;
        }
        try {
            this.pillagers.clear();
            HashSet<Integer> currentPillagers = new HashSet<Integer>();
            for (class_1297 entity : this.mc.field_1687.method_18112()) {
                class_1604 pillager;
                double distance;
                if (!(entity instanceof class_1604) || !((distance = (double)this.mc.field_1724.method_5739((class_1297)(pillager = (class_1604)entity))) <= (double)((Integer)this.maxDistance.get()).intValue())) continue;
                this.pillagers.add(pillager);
                currentPillagers.add(entity.method_5628());
            }
            if (((Boolean)this.showCount.get()).booleanValue() && this.pillagers.size() != this.lastPillagerCount) {
                if (this.pillagers.size() > 0) {
                    String message = "Found " + this.pillagers.size() + " pillager(s) nearby";
                    switch (((NotificationMode)((Object)this.notificationMode.get())).ordinal()) {
                        case 0: {
                            this.info("\u00a75[\u00a7dPillagerESP\u00a75] \u00a7c" + message, new Object[0]);
                            break;
                        }
                        case 1: {
                            this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8399, this.title, message));
                            break;
                        }
                        case 2: {
                            this.info("\u00a75[\u00a7dPillagerESP\u00a75] \u00a7c" + message, new Object[0]);
                            this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8399, this.title, message));
                        }
                    }
                }
                this.lastPillagerCount = this.pillagers.size();
            }
            if (!currentPillagers.isEmpty() && !currentPillagers.equals(this.detectedPillagers)) {
                HashSet newPillagers = new HashSet(currentPillagers);
                newPillagers.removeAll(this.detectedPillagers);
                if (!newPillagers.isEmpty()) {
                    this.detectedPillagers.addAll(newPillagers);
                    this.handlePillagerDetection(this.pillagers.size());
                }
            } else if (currentPillagers.isEmpty()) {
                this.detectedPillagers.clear();
            }
            for (class_1604 pillager : this.pillagers) {
                if (pillager == null || !pillager.method_5805()) continue;
                try {
                    this.renderPillager(pillager, event);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handlePillagerDetection(int pillagerCount) {
        if (((Boolean)this.enableWebhook.get()).booleanValue()) {
            this.sendWebhookNotification(pillagerCount);
        }
        if (((Boolean)this.toggleOnFind.get()).booleanValue()) {
            this.toggle();
        }
        if (((Boolean)this.enableDisconnect.get()).booleanValue()) {
            String message = pillagerCount == 1 ? "Pillager detected!" : String.format("%d pillagers detected!", pillagerCount);
            this.disconnectFromServer(message);
        }
    }

    private void sendWebhookNotification(int pillagerCount) {
        String url = ((String)this.webhookUrl.get()).trim();
        if (url.isEmpty()) {
            this.warning("Webhook URL not configured!", new Object[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                String pillagerText = pillagerCount == 1 ? "pillager" : "pillagers";
                String description = String.format("%d %s detected!", pillagerCount, pillagerText);
                String coordinates = "Unknown";
                if (this.mc.field_1724 != null) {
                    coordinates = String.format("X: %.0f, Y: %.0f, Z: %.0f", this.mc.field_1724.method_23317(), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321());
                }
                String jsonPayload = String.format("{\"content\":\"%s\",\"username\":\"PillagerESP\",\"avatar_url\":\"https://minecraft.wiki/images/4/4b/Pillager_JE2_BE2.png\",\"embeds\":[{\"title\":\"\u2694\ufe0f Pillager Alert\",\"description\":\"%s\",\"color\":16711680,\"thumbnail\":{\"url\":\"https://minecraft.wiki/images/4/4b/Pillager_JE2_BE2.png\"},\"fields\":[{\"name\":\"Count\",\"value\":\"%d\",\"inline\":true},{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Coordinates\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Time\",\"value\":\"<t:%d:R>\",\"inline\":true}],\"footer\":{\"text\":\"Sent by Catalyst\"}}]}", messageContent.replace("\"", "\\\""), description.replace("\"", "\\\""), pillagerCount, serverInfo.replace("\"", "\\\""), coordinates.replace("\"", "\\\""), System.currentTimeMillis() / 1000L);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 204) {
                    this.info("Webhook notification sent successfully", new Object[0]);
                } else {
                    this.error("Webhook failed with status: " + response.statusCode(), new Object[0]);
                }
            }
            catch (IOException | InterruptedException e) {
                this.error("Failed to send webhook: " + e.getMessage(), new Object[0]);
            }
        });
    }

    private void disconnectFromServer(String reason) {
        if (this.mc.field_1687 != null && this.mc.method_1562() != null) {
            this.mc.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)reason));
            this.info("Disconnected from server - " + reason, new Object[0]);
        }
    }

    private void renderPillager(class_1604 pillager, Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_243 pos = pillager.method_19538();
        class_238 box = pillager.method_5829();
        this.renderESP(pillager, box, event);
        if (((Boolean)this.tracersEnabled.get()).booleanValue()) {
            this.renderTracers(pillager, pos, event);
        }
    }

    private void renderESP(class_1604 pillager, class_238 box, Render3DEvent event) {
        Color color = new Color((Color)this.espColor.get());
        event.renderer.box(box, color, color, (ShapeMode)this.shapeMode.get(), 0);
    }

    private void renderTracers(class_1604 pillager, class_243 pos, Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        Color color = new Color((Color)this.tracerColor.get());
        class_243 pillagerCenter = class_243.method_24953((class_2382)new class_2338((int)pos.field_1352, (int)(pos.field_1351 + (double)(pillager.method_17682() / 2.0f)), (int)pos.field_1350));
        switch (((TracersMode)((Object)this.tracersMode.get())).ordinal()) {
            case 0: {
                event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, pillagerCenter.field_1352, pillagerCenter.field_1351, pillagerCenter.field_1350, color);
                break;
            }
            case 1: {
                class_238 dotBox = new class_238(pillagerCenter.field_1352 - 0.1, pillagerCenter.field_1351 - 0.1, pillagerCenter.field_1350 - 0.1, pillagerCenter.field_1352 + 0.1, pillagerCenter.field_1351 + 0.1, pillagerCenter.field_1350 + 0.1);
                event.renderer.box(dotBox, color, color, ShapeMode.Both, 0);
                break;
            }
            case 2: {
                event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, pillagerCenter.field_1352, pillagerCenter.field_1351, pillagerCenter.field_1350, color);
                class_238 dotBox2 = new class_238(pillagerCenter.field_1352 - 0.1, pillagerCenter.field_1351 - 0.1, pillagerCenter.field_1350 - 0.1, pillagerCenter.field_1352 + 0.1, pillagerCenter.field_1351 + 0.1, pillagerCenter.field_1350 + 0.1);
                event.renderer.box(dotBox2, color, color, ShapeMode.Both, 0);
            }
        }
    }

    public String getInfoString() {
        return String.valueOf(this.pillagers.size());
    }

    public static enum NotificationMode {
        Chat,
        Toast,
        Both;

    }

    public static enum TracersMode {
        Line,
        Dot,
        Both;

    }
}

